﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using PhotoApp.Models;

namespace PhotoApp.Controllers
{
    public class TagMastersController : Controller
    {
        private ApplicationDbContext db = new ApplicationDbContext();

        // GET: TagMasters
        public ActionResult Index()
        {
            return View(db.TagMaster.ToList());
        }

        // GET: TagMasters/Details/5
        public ActionResult Details(Guid? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            TagMaster tagMaster = db.TagMaster.Find(id);
            if (tagMaster == null)
            {
                return HttpNotFound();
            }
            return View(tagMaster);
        }

        // GET: TagMasters/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: TagMasters/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "TagMasterId,TagName,Details,CreatedOn")] TagMaster tagMaster)
        {
            if (ModelState.IsValid)
            {
                tagMaster.TagMasterId = Guid.NewGuid();
                db.TagMaster.Add(tagMaster);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(tagMaster);
        }

        // GET: TagMasters/Edit/5
        public ActionResult Edit(Guid? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            TagMaster tagMaster = db.TagMaster.Find(id);
            if (tagMaster == null)
            {
                return HttpNotFound();
            }
            return View(tagMaster);
        }

        // POST: TagMasters/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "TagMasterId,TagName,Details,CreatedOn")] TagMaster tagMaster)
        {
            if (ModelState.IsValid)
            {
                db.Entry(tagMaster).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(tagMaster);
        }

        // GET: TagMasters/Delete/5
        public ActionResult Delete(Guid? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            TagMaster tagMaster = db.TagMaster.Find(id);
            if (tagMaster == null)
            {
                return HttpNotFound();
            }
            return View(tagMaster);
        }

        // POST: TagMasters/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(Guid id)
        {
            TagMaster tagMaster = db.TagMaster.Find(id);
            db.TagMaster.Remove(tagMaster);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
