namespace PhotoApp.Migrations
{
    using System;
    using System.Data.Entity.Migrations;
    
    public partial class AddTablePhotos : DbMigration
    {
        public override void Up()
        {
            CreateTable(
                "dbo.Photos",
                c => new
                    {
                        PhotosId = c.Guid(nullable: false),
                        UserID = c.String(maxLength: 128),
                        TagName = c.String(maxLength: 50),
                        ShortImage = c.String(),
                        OriginalImage = c.String(),
                        Details = c.String(),
                        CreatedOn = c.DateTime(nullable: false),
                    })
                .PrimaryKey(t => t.PhotosId)
                .ForeignKey("dbo.AspNetUsers", t => t.UserID)
                .Index(t => t.UserID);
            
        }
        
        public override void Down()
        {
            DropForeignKey("dbo.Photos", "UserID", "dbo.AspNetUsers");
            DropIndex("dbo.Photos", new[] { "UserID" });
            DropTable("dbo.Photos");
        }
    }
}
